@extends('layouts.app')

@section('center')

<link rel="stylesheet" href="{{ asset('assets/vendor/bs-select/bs-select.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/vendor/datepicker/css/classic.css') }}" />
<link rel="stylesheet" href="{{ asset('assets/vendor/datepicker/css/classic.date.css') }}" />

<div class="row gutters">
			<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
				<form action="{{route('timeDomainGraph')}}">
				<div class="row gutters">
			<div class="col-xl-2 col-lg-2 col-md-2 col-sm-2">

				<div class="form-group">
					<label class="label">Device ID</label>
					<select class="form-control selectpicker" data-live-search="true" class="form-control " name="DeviceId">
						<option value=''>Select Device ID</option>
						@foreach($tr_data as $k => $row)
						<option value="{{$row->global_device_id}}" 
                            @isset($_GET["DeviceId"])
                                        @if($_GET["DeviceId"]==$row->global_device_id) {{'selected'}}
                                        @endif
                            @endisset>{{$row->global_device_id}}</option>
						@endforeach

					</select>
				</div>
               



			</div>
           


			

			<div class="col-xl-2 col-lg col-md-2 col-sm-2 col-12 ">
			<div class="form-group">
					<label class="label">&nbsp;</label>
					<button type="submit" class="form-control btn btn-primary generate">Generate</button>
				</div>

			</div>
				</div>
			</form>
			</div>



@if(!empty($graph_data) )
@foreach($graph_data as $channelGroup => $groupSamples)
        <h4>Channel Group {{ $channelGroup }}</h4><br/>
        <div class="row">
        <div class="col-md-6 mb-4">
        <canvas id="vChart-{{ $channelGroup }}" width="600" height="400"></canvas>
        </div>

        <div class="col-md-6 mb-4">
        <canvas id="iChart-{{ $channelGroup }}" width="600" height="400"></canvas>
        </div>
        </div>

    @endforeach
@endif

@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chartjs-adapter-date-fns@latest"></script>
<script src="{{ asset('assets/vendor/bs-select/bs-select.min.js') }}"></script>


<script>
        const allSamples = @json($graph_data);

        Object.entries(allSamples).forEach(([channelGroup, groupSamples]) => {
            const labels = groupSamples.map((_, index) => index + 1);

            const v1 = groupSamples.map(s => s.v1);
            const v2 = groupSamples.map(s => s.v2);
            const v3 = groupSamples.map(s => s.v3);

            const i1 = groupSamples.map(s => s.i1);
            const i2 = groupSamples.map(s => s.i2);
            const i3 = groupSamples.map(s => s.i3);

            // Voltage Chart
            const vCtx = document.getElementById(`vChart-${channelGroup}`);
            if (vCtx) {
                new Chart(vCtx, {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [
                            { label: 'V1', data: v1, borderColor: 'red', fill: false },
                            { label: 'V2', data: v2, borderColor: 'green', fill: false },
                            { label: 'V3', data: v3, borderColor: 'blue', fill: false },
                        ]
                    },
                    options: {
                        responsive: true,
                        title: { display: true, text: `Voltage (Group ${channelGroup})` }
                    }
                });
            }

            // Current Chart
            const iCtx = document.getElementById(`iChart-${channelGroup}`);
            if (iCtx) {
                new Chart(iCtx, {
                    type: 'line',
                    data: {
                        labels: labels,
                        datasets: [
                            { label: 'I1', data: i1, borderColor: 'orange', fill: false },
                            { label: 'I2', data: i2, borderColor: 'purple', fill: false },
                            { label: 'I3', data: i3, borderColor: 'brown', fill: false },
                        ]
                    },
                    options: {
                        responsive: true,
                        title: { display: true, text: `Current (Group ${channelGroup})` }
                    }
                });
            }
        });
    </script>
@endpush
